/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5455;
import net.minecraft.class_60;
import net.minecraft.class_8490;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_60.class})
public class LootManagerMixin {
    @Unique
    private static final Map<Object, class_5455.class_6890> dynamicRegistryManagerMap = Collections.synchronizedMap(new IdentityHashMap());

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;runAsync(Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void load(class_8490 type, class_3300 resourceManager, Executor executor, Map<class_8490<?>, Map<class_2960, ?>> results, CallbackInfoReturnable<CompletableFuture<?>> cir, Map map) {
        dynamicRegistryManagerMap.put(map, ResourceConditionsImpl.CURRENT_REGISTRIES.get());
    }

    @Inject(method={"method_51189"}, at={@At(value="HEAD")})
    private static void runAsync(class_3300 resourceManager, class_8490 lootDataType, Map map, CallbackInfo ci) {
        assert (ResourceConditionsImpl.CURRENT_REGISTRIES.get() == null);
        ResourceConditionsImpl.CURRENT_REGISTRIES.set(Objects.requireNonNull(dynamicRegistryManagerMap.remove(map)));
    }

    @Inject(method={"method_51195"}, at={@At(value="HEAD")}, cancellable=true)
    private static void applyResourceConditions(class_8490 lootDataType, Map map, class_2960 id, JsonElement json, CallbackInfo ci) {
        JsonObject obj;
        if (json.isJsonObject() && (obj = json.getAsJsonObject()).has("fabric:load_conditions")) {
            boolean matched = ResourceConditions.objectMatchesConditions(obj);
            if (!matched) {
                ci.cancel();
            }
            if (ResourceConditionsImpl.LOGGER.isDebugEnabled()) {
                String verdict = matched ? "Allowed" : "Rejected";
                ResourceConditionsImpl.LOGGER.debug("{} resource of type {} with id {}", new Object[]{verdict, lootDataType.method_51214(), id});
            }
        }
    }

    @Inject(method={"method_51189"}, at={@At(value="RETURN")})
    private static void runAsyncEnd(class_3300 resourceManager, class_8490 lootDataType, Map map, CallbackInfo ci) {
        ResourceConditionsImpl.CURRENT_REGISTRIES.remove();
    }
}

